#!/usr/bin/env python3

import os

# --- 1. Inputs (from Volume 1 examples) ---
t_collapse   = 0.9e-3   # seconds (example)
tau_nerve    = 20e-3    # seconds (example)

# --- 2. Compute kappa ---
kappa = tau_nerve / t_collapse

# --- 3. Save result ---
os.makedirs("results", exist_ok=True)
with open("results/kappa.txt", "w") as f:
    f.write(f"{kappa:.6f}")

print(f"✔ κ = {kappa:.6f} written to results/kappa.txt")
